/*
 * Decompiled with CFR 0.152.
 */
package jmc.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.SecureConnection;
import javax.microedition.io.StreamConnection;
import jmc.connection.CommunicationManager;
import util.Datas;

public class meConnector
extends Thread {
    private StreamConnection connection = null;
    private CommunicationManager _cm = null;
    private int _port;
    private String _hostname;

    public meConnector(String hostname, int port, CommunicationManager cm) {
        this._hostname = hostname;
        this._cm = cm;
        this._port = port;
    }

    public void run() {
        StringBuffer connectorStringBuffer = Datas.isSSL ? new StringBuffer("ssl://") : new StringBuffer("socket://");
        connectorStringBuffer.append(this._hostname);
        connectorStringBuffer.append(":");
        connectorStringBuffer.append(this._port);
        connectorStringBuffer.append("");
        String connectorString = connectorStringBuffer.toString().trim();
        System.out.println(connectorString);
        try {
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
            this.connection = Datas.isSSL ? (SecureConnection)Connector.open((String)connectorString) : (StreamConnection)Connector.open((String)connectorString);
            this._cm.notifyConnect(this.connection, this.openInputStream(), this.openOutputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Connection in cancel:" + e.getMessage());
            this._cm.notifyNoConnectionOn("I can't connect, server is unreachable");
        }
    }

    public InputStream openInputStream() throws IOException {
        return this.connection.openInputStream();
    }

    public OutputStream openOutputStream() throws IOException {
        return this.connection.openOutputStream();
    }

    public StreamConnection getConnection() {
        return this.connection;
    }
}

